//
//  Demo_App_ClipApp.swift
//  Demo App Clip
//
//  Created by Gero Gerber on 01.11.20.
//

import AppClip
import CoreLocation
import SwiftUI

@main
struct Demo_App_ClipApp: App {

    var model = AppClipModel()

    var body: some Scene {
        WindowGroup {
            ContentView()
                .environmentObject(model)
                .onContinueUserActivity(NSUserActivityTypeBrowsingWeb) { userActivity in

                    // Write to shared UserDefaults
                    guard let sharedUserDefaults = UserDefaults(suiteName: "group.heiseAppClips.appClipMigration") else { return }
                    let numberOfAppClipInvocations = sharedUserDefaults.integer(forKey: "appClipInvocations") + 1
                    sharedUserDefaults.set(numberOfAppClipInvocations, forKey: "appClipInvocations")

                    // Write to shared container
                    guard var containerUrl = FileManager.default.containerURL(forSecurityApplicationGroupIdentifier: "group.heiseAppClips.appClipMigration") else { return }
                    containerUrl.appendPathComponent("test")
                    try! "The App Clip was invoked '\(numberOfAppClipInvocations) times".write(to: containerUrl, atomically: false, encoding: .utf8)

                    guard let payload = userActivity.appClipActivationPayload else {
                        return
                    }

                    guard let url = payload.url,
                          let components = NSURLComponents(url: url, resolvingAgainstBaseURL: true) else {
                        return
                    }

                    let locationFromExperience = components.path!.replacingOccurrences(of: "/", with: "")

                    let locations = [
                        "dortmund": CLLocationCoordinate2D(latitude: 51.548411, longitude: 7.365163),
                        "münchen": CLLocationCoordinate2D(latitude: 48.144763, longitude: 11.577865),
                        "berlin": CLLocationCoordinate2D(latitude: 52.523860, longitude: 13.378073)
                    ]

                    let region = CLCircularRegion(center: locations[locationFromExperience]!, radius: 200, identifier: locationFromExperience)

                    payload.confirmAcquired(in: region) { (isInsideRegion, error) in
                        if let error = error {
                            print(error.localizedDescription)
                        }

                        print("Is inside Region: \(isInsideRegion)")
                    }

                    self.model.path = components.path
                    self.model.queryItems = components.queryItems

                    let notificationCenter = UNUserNotificationCenter.current()
                    notificationCenter.getNotificationSettings { settings in
                        if settings.authorizationStatus == .ephemeral { return }
                        // Andernfalls explizit nach Authorization fragen
                    }
                }
        }
    }
}
